# =基盤システム/ゲームマスター
#
#
#
#
# ==更新履歴
#   Date     Version Author Comment
# ==14/12/13 2.0.0   トリス 統合A～E A
# ==17/05/16 2.0.4   トリス 統合V～W V
#

#==============================================================================
# ■ Game_Battler
#==============================================================================
class Game_Battler < Game_BattlerBase
  #--------------------------------------------------------------------------
  # ○ スキル／アイテムの適用テスト
  #    使用対象が全快しているときの回復禁止などを判定する。
  #--------------------------------------------------------------------------
  def item_test(user, item)
    return false if (item.for_dead_friend? != dead?) && !(user.game_master? && item.for_user?)
    return true if $game_party.in_battle
    return true if item.for_opponent?
    return true if item.damage.recover? && item.damage.to_hp? && hp < mhp
    return true if item.damage.recover? && item.damage.to_mp? && mp < mmp
    return true if item_has_any_valid_effects?(user, item)

    false
  end

  #--------------------------------------------------------------------------
  # ● ゲームマスター？
  #--------------------------------------------------------------------------
  def game_master?
    false
  end

  #--------------------------------------------------------------------------
  # ● ゲームマスターならばオブザーバーを返す
  #--------------------------------------------------------------------------
  def master_observer
    game_master? ? @observer : self
  end
end

#==============================================================================
# ■ Game_Master
#==============================================================================
class Game_Master < Game_Battler
  attr_reader :observer

  #--------------------------------------------------------------------------
  # ● オブジェクト初期化
  #--------------------------------------------------------------------------
  def initialize(observer)
    super()
    @observer = observer
    self.hp = mhp
    self.mp = mmp
    self.tp = max_tp
  end

  #--------------------------------------------------------------------------
  # ● 最大HPの取得
  #--------------------------------------------------------------------------
  def mhp
    NWConst::Actor::MAX_MHP
  end

  #--------------------------------------------------------------------------
  # ● 最大MPの取得
  #--------------------------------------------------------------------------
  def mmp
    NWConst::Actor::MAX_PARAM
  end

  #--------------------------------------------------------------------------
  # ● 最大TPの取得
  #--------------------------------------------------------------------------
  def max_tp
    NWConst::Actor::MAX_MSP
  end

  #--------------------------------------------------------------------------
  # ● 表示名の取得
  #--------------------------------------------------------------------------
  def name
    @observer.name
  end

  #--------------------------------------------------------------------------
  # ● 特徴を保持する全オブジェクトの配列取得
  #--------------------------------------------------------------------------
  def feature_objects
    @observer.feature_objects
  end

  #--------------------------------------------------------------------------
  # ● 通常能力値の基本値取得
  #--------------------------------------------------------------------------
  def param(param_id)
    raise # このメソッドが呼ばれていないことを確認
  end

  #--------------------------------------------------------------------------
  # ● ID 取得
  #--------------------------------------------------------------------------
  def id
    @observer.id
  end

  #--------------------------------------------------------------------------
  # ● 味方ユニットを取得
  #--------------------------------------------------------------------------
  def friends_unit
    @observer.friends_unit
  end

  #--------------------------------------------------------------------------
  # ● 敵ユニットを取得
  #--------------------------------------------------------------------------
  def opponents_unit
    @observer.opponents_unit
  end

  #--------------------------------------------------------------------------
  # ● 武器タイプ配列の取得
  #--------------------------------------------------------------------------
  def wtypes
    @observer.wtypes
  end

  #--------------------------------------------------------------------------
  # ● ゲームマスター？
  #--------------------------------------------------------------------------
  def game_master?
    true
  end

  #--------------------------------------------------------------------------
  # ● アクター？
  #--------------------------------------------------------------------------
  def actor?
    @observer.actor?
  end

  #--------------------------------------------------------------------------
  # ● エネミー？
  #--------------------------------------------------------------------------
  def enemy?
    @observer.enemy?
  end

  def word_id
    @observer.word_id
  end

  #--------------------------------------------------------------------------
  # ● アクターの取得
  #--------------------------------------------------------------------------
  def actor
    @observer.actor? ? @observer.actor : nil
  end

  #--------------------------------------------------------------------------
  # ● ベースレベルの取得
  #--------------------------------------------------------------------------
  def base_level
    @observer.actor? ? @observer.base_level : 1
  end

  #--------------------------------------------------------------------------
  # ● 職業レベルの取得
  #--------------------------------------------------------------------------
  def class_level
    @observer.actor? ? @observer.class_level : 1
  end

  #--------------------------------------------------------------------------
  # ● 種族レベルの取得
  #--------------------------------------------------------------------------
  def tribe_level
    @observer.actor? ? @observer.tribe_level : 1
  end

  #--------------------------------------------------------------------------
  # ● 通常攻撃 アニメーション ID の取得
  #--------------------------------------------------------------------------
  def atk_animation_ids
    @observer.actor? ? @observer.atk_animation_ids : [0]
  end

  #--------------------------------------------------------------------------
  # ● エネミーの取得
  #--------------------------------------------------------------------------
  def enemy
    @observer.enemy? ? @observer.enemy : nil
  end

  #--------------------------------------------------------------------------
  # ● 戦闘行動終了時の処理
  #--------------------------------------------------------------------------
  def on_action_end
    @result.clear
  end

  def index
    @observer.index
  end

  def od_movable?
    true
  end

  def skill_hp_cost(skill)
    0
  end

  def skill_mp_cost(skill)
    0
  end

  def skill_tp_cost(skill)
    0
  end
end
